;;; Dezyne --- Dezyne command line tools
;;;
;;; Copyright © 2017, 2018, 2019, 2020, 2021, 2022, 2023, 2024, 2025 Janneke Nieuwenhuizen <janneke@gnu.org>
;;; Copyright © 2018, 2023, 2026 Rutger van Beusekom <rutger@dezyne.org>
;;;
;;; This file is part of Dezyne.
;;;
;;; Dezyne is free software: you can redistribute it and/or modify it
;;; under the terms of the GNU Affero General Public License as
;;; published by the Free Software Foundation, either version 3 of the
;;; License, or (at your option) any later version.
;;;
;;; Dezyne is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; Affero General Public License for more details.
;;;
;;; You should have received a copy of the GNU Affero General Public
;;; License along with Dezyne.  If not, see <http://www.gnu.org/licenses/>.
;;;
;;; Commentary:
;;;
;;; Compile-time configuration of dzn.  When adding a substitution
;;; variable here, make sure to have configure substitute it.
;;;
;;; Code:

(define-module (dzn config)
  #:use-module (dzn shell-util)
  #:export (%bindir
            %builddir
            %copyright-info
            %datadir
            %datarootdir
            %dzn
            %feature-alist
            %guilemoduledir
            %guileobjectdir
            %default-languages
            %default-queue-size
            %default-queue-size-defer
            %default-queue-size-external
            %license-info
            %package
            %package-name
            %package-version
            %prefix
            %queue-size
            %queue-size-defer
            %queue-size-external
            %runtime-dir
            %srcdir
            %template-dir
            %test-dir
            %version-major
            %version-minor
            %version-patch))

(define %package
  (or (and (getenv "DZN_UNINSTALLED") "dezyne")
      "dezyne"))

(define %prefix
  (or (and (getenv "DZN_UNINSTALLED") (getenv "DZN_PREFIX"))
      "/gnu/store/g229jyhmmk9fkbgjn75jz8cz1397b32c-dezyne-mingw-2.19.2.145-f32a0"))

(define %srcdir
  ".")

(define %builddir
  ".")

(define %datadir
  (or (and (getenv "DZN_UNINSTALLED") %prefix)
      "/gnu/store/g229jyhmmk9fkbgjn75jz8cz1397b32c-dezyne-mingw-2.19.2.145-f32a0/share"))

(define %datarootdir
  (or (and (getenv "DZN_UNINSTALLED") %prefix)
      "/gnu/store/g229jyhmmk9fkbgjn75jz8cz1397b32c-dezyne-mingw-2.19.2.145-f32a0/share"))

(define %pkgdatadir
  (or (and (getenv "DZN_UNINSTALLED") %prefix)
      (getenv "DZN_DATADIR")
      (string-append %datadir "/" %package)))

(define %bindir
  (or (and (getenv "DZN_UNINSTALLED") (string-append %builddir "/bin"))
      "/gnu/store/g229jyhmmk9fkbgjn75jz8cz1397b32c-dezyne-mingw-2.19.2.145-f32a0/bin"))

(define %runtime-dir
  (string-append %pkgdatadir "/runtime"))

(define %template-dir
  (string-append
   %pkgdatadir
   (if (getenv "DZN_UNINSTALLED") "/dzn" "")
   "/templates"))

(define %test-dir
  (string-append %pkgdatadir "/test"))

(define %guilemoduledir
  "/gnu/store/g229jyhmmk9fkbgjn75jz8cz1397b32c-dezyne-mingw-2.19.2.145-f32a0/share/guile/site/3.0")

(define %guileobjectdir
  "/gnu/store/g229jyhmmk9fkbgjn75jz8cz1397b32c-dezyne-mingw-2.19.2.145-f32a0/lib/guile/3.0/site-ccache")

(define %package-name
  "Dezyne")

(define %package-version
  "2.19.2.145-f32a0")

(define %version-major
  2)

(define %version-minor
  19)

(define %version-patch
  2)

(define %dzn
  (if (mingw?) "dzn.cmd"
      (string-append %bindir "/dzn")))

(define %copyright-info
  "Copyright (C) 2014-2023 the Dezyne authors
")

(define %license-info
  "License AGPLv3+: GNU AGPL version 3 or later <https://gnu.org/licenses/agpl.html>
This is free software: you are free to change and redistribute it.
There is NO WARRANTY, to the extent permitted by law.
")

(define %libpth "@LIBPTH@")
(define %have-libpth "no")
(define %feature-alist
  '(("block" . ("c" "c++" "cs" "scheme"))
    ("calling_context" . ("c" "c++" "cs" "scheme"))
    ("collateral" . ("c" "c++" "cs" "scheme"))
    ("defer" . ("c" "c++" "cs" "scheme"))
    ("flush" . ("c" "c++" "cs" "scheme"))
    ("foreign_function" . ("c++"))
    ("global_function" . ("c" "c++" "javacsript" "scheme"))
    ("inject" . ("c" "c++" "cs" "javacsript" "scheme"))
    ("reply-data" . ("c" "c++" "javascript" "scheme"))
    ("shared" . ("c++"))
    ("shell" . ("c" "c++" "cs" "scheme"))
    ("space" . ("c" "c++" "cs" "javascript" "scheme"))))


;;;
;;; Defaults.
;;;
(define %default-languages
  (string-split (string-trim-both "c++") #\space))

;;; The component queue.
(define %default-queue-size 3)
(define %queue-size (make-parameter %default-queue-size))

;;; The defer queue.
(define %default-queue-size-defer 2)
(define %queue-size-defer (make-parameter %default-queue-size-defer))

;;; The external queue.
(define %default-queue-size-external 1)
(define %queue-size-external (make-parameter %default-queue-size-external))
