;;; Verum-Dezyne --- An IDE for Dezyne
;;;
;;; Copyright © 2021 Rutger van Beusekom <rutger.van.beusekom@verum.com>
;;;
;;; This file is part of Verum-Dezyne.
;;;
;;; Verum-Dezyne is property of Verum Software Tools BV <support@verum.com>.
;;; All rights reserved.

(define-module (ide port-util)
  #:export (with-output+error-to-string))

(define (with-output-and-error-to-ports output error thunk)
  (parameterize ((current-output-port output)
                 (current-error-port error))
    (thunk)))

(define (with-output+error-to-string thunk)
  (let ((output (open-output-string))
        (error (open-output-string)))
    (with-output-and-error-to-ports output error thunk)
    (values (get-output-string output) (get-output-string error))))
