// dzn-runtime -- Dezyne runtime library
//
// Copyright © 2024, 2025 Rutger van Beusekom <rutger@dezyne.org>
//
// This file is part of dzn-runtime.
//
// All rights reserved.
//
//
// Commentary:
//
// Code:

#include <dzn/coroutine.hh>

namespace dzn
{
thread_local std::thread::id s_thread_id;
void set_thread_id (std::thread::id id)
{
  s_thread_id = id;
}
std::thread::id get_thread_id ()
{
  return s_thread_id;
}
#if HAVE_BOOST_COROUTINE
coroutine::coroutine (size_t id, std::thread::id, std::function<void()>&& worker)
  : id (id)
  , context ([this, worker] (dzn::yield &yield)
#else
coroutine::coroutine (size_t id, std::thread::id thread_id, std::function<void()>&& worker)
  : id (id)
  , context (thread_id, [this, worker] (dzn::yield &yield)
#endif
  {
    this->yield = std::move (yield);
    worker ();
  })
  , port ()
  , finished ()
  , skip_block ()
{}
coroutine::coroutine ()
  : id (0)
  , context ()
  , port ()
  , finished ()
  , skip_block ()
{}
void coroutine::yield_to (dzn::coroutine &that)
{
  this->yield (that.context);
}
#if HAVE_BOOST_COROUTINE
void coroutine::call (dzn::coroutine &)
{
  this->context ();
}
void coroutine::release () {}
#else //!HAVE_BOOST_COROUTINE
void coroutine::call (dzn::coroutine &that)
{
  this->context.call (that.context);
}
void coroutine::release ()
{
  this->context.release ();
}
#endif // !HAVE_BOOST_COROUTINE
}
//version: 2.19.2.99-9ba7cc
